package editor;

import game.CustomImageDataII;
import game.IntRect;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;
import java.io.BufferedWriter;

public class WidgetScreenObject extends ScreenObject implements CloneableScreenObject {
	
	private IntRect clickRect;
	private WidgetScreenPaletteObject paletteObj;
	
	private boolean isSelected;
	
	public WidgetScreenObject(int x, int y, WidgetScreenPaletteObject thePaletteObj) {
		
		paletteObj = thePaletteObj;
		
		int maxWidth = 0;
		int maxHeight = 0;
		
		CustomImageDataII theImageArray[] = thePaletteObj.getImageArray();
		
		for(CustomImageDataII cid : theImageArray) {
			if(cid.getDesiredWidth() > maxWidth)
				maxWidth = cid.getDesiredWidth();
			if(cid.getDesiredHeight() > maxHeight)
				maxHeight = cid.getDesiredHeight();
		}
		
		
		clickRect = new IntRect(x - maxWidth / 2, y - maxHeight / 2, maxWidth, maxHeight);
		
	}
	
	
	@Override
	public void draw(Graphics g) {
		
		if(paletteObj == null)
			return;
		
		CustomImageDataII imageArray[] = paletteObj.getImageArray();
		
		Point p = clickRect.getCenter();
		
		if(imageArray != null && imageArray.length > 0)
			imageArray[0].drawObjectIgnoreBounds(g, p.x, p.y);
		
		if(isSelected) {
			drawSelectionOverObject(g);
		}
		
	}

	@Override
	public IntRect getClickRect() {
		return clickRect;
	}


	public boolean isSelected() {
		
		return isSelected;
	}


	public void setSelected(boolean isSelected) {
		this.isSelected = isSelected;
	}


	@Override
	public void setClickRect(IntRect newRect) {
		clickRect = newRect;
	}

	public WidgetScreenPaletteObject getPaletteObject() {
		return paletteObj;
	}
	
	
	public void writeBgWidgetOutToFile(BufferedWriter out) throws Exception {
		writeWidgetOutToFile(out, "bgwidget:");
	}
	
	public void writeCommentWidgetOutToFile(BufferedWriter out) throws Exception {
		writeWidgetOutToFile(out, "commentWidget:");
	}
	
	
	public void writeFgWidgetOutToFile(BufferedWriter out) throws Exception {
		writeWidgetOutToFile(out, "fgwidget:");
	}
	
	
	
	private void writeWidgetOutToFile(BufferedWriter out, String header) throws Exception {
		
		out.write(header);
		out.newLine();
		
		Point centerPoint = getClickRect().getCenter();
		
		out.write("x:");
		out.write(Integer.toString(centerPoint.x));
		out.newLine();
		
		out.write("y:");
		out.write(Integer.toString(centerPoint.y));
		out.newLine();
		
		CustomImageDataII frames[] = paletteObj.getImageArray();
		
		out.write("frameCount:");
		out.write(Integer.toString(frames.length));
		out.newLine();
		
		for(CustomImageDataII frame : frames) {
			out.write(frame.getFileName());
			out.write("*");
			out.write(CustomAnimationPanel.convertColorToString(frame.getTransparentColor()));
			out.write("*");
			out.write(Integer.toString(frame.getDesiredWidth()));
			out.write("*");
			out.write(Integer.toString(frame.getDesiredHeight()));
			
			out.newLine();
		}
		
		out.write("/widget");
		out.newLine();
		
		out.newLine();
	}
	
	
	
	public WidgetScreenObject clone(ImageObserver io) {
		
		Point centerPoint = getClickRect().getCenter();
		
		WidgetScreenObject returnValue = new WidgetScreenObject(centerPoint.x, centerPoint.y, this.paletteObj);
		
		return returnValue;
	}
	
	@Override
	public int getLayer() {
		
		return 4;
	}
	
}
